from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from app.v1.models.platform.templates import Template, TemplateCreate, TemplateList
from app.v1.services.platform import templates as template_service
from typing import Optional
from datetime import datetime

router = APIRouter()

@router.post("/", response_model=Template)
def create_template(template: TemplateCreate, db=Depends(database.get_mongo_db)):
    return template_service.create_template_service(template, db)

@router.get("/", response_model=TemplateList)
def list_templates(account_id: str, db=Depends(database.get_mongo_db)):
    return template_service.list_template_service(account_id, db)

@router.get("/{template_id}", response_model=Template)
def get_template(template_id: str, db=Depends(database.get_mongo_db)):
    return template_service.get_template_by_id(template_id, db)
